<?php
// Target URL
$url = "https://romanticgolpo.com/category/%E0%A6%86%E0%A6%AE%E0%A7%83%E0%A6%A4%E0%A7%8D%E0%A6%AF%E0%A7%81-%E0%A6%AD%E0%A6%BE%E0%A6%B2%E0%A7%8B%E0%A6%AC%E0%A6%BE%E0%A6%B8%E0%A6%BF-%E0%A6%A4%E0%A7%8B%E0%A6%95%E0%A7%87/";

// Step 1: Get HTML
$html = file_get_contents($url);
if (!$html) {
    die("Failed to fetch URL!");
}

// Step 2: Load into DOM
libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
libxml_clear_errors();

// Step 3: Create XPath
$xpath = new DOMXPath($dom);

// Step 4: Find all story blocks (they have class `td_module_2`)
$items = $xpath->query("//div[contains(@class, 'td_module_2')]");

// Step 5: Loop through and extract data
foreach ($items as $item) {
    // Get title link
    $aTag = $xpath->query(".//h3[@class='entry-title td-module-title']/a", $item)->item(0);
    $title = $aTag ? trim($aTag->nodeValue) : '';
    $link  = $aTag ? $aTag->getAttribute('href') : '';

    // Get image URL (data-src or src)
    $imgTag = $xpath->query(".//img", $item)->item(0);
    $img = '';
    if ($imgTag) {
        $img = $imgTag->getAttribute('data-src') ?: $imgTag->getAttribute('src');
    }

    // Get excerpt (if exists)
    $excerptTag = $xpath->query(".//div[contains(@class, 'td-excerpt')]", $item)->item(0);
    $excerpt = $excerptTag ? trim($excerptTag->nodeValue) : '';

 echo "Title: $title<br>";
echo "Link: $link<br>";
echo "Image: $img<br>";
echo "Excerpt: $excerpt<br><br>";

}
?>
