<?php
require 'db_connect.php';

$errors = [];
$success = "";

// ---------------------------
// Fetch Categories
// ---------------------------
$cats = [];
$q1 = mysqli_query($conn, "SELECT * FROM categories ORDER BY category ASC");
while($r = mysqli_fetch_assoc($q1)) $cats[] = $r;

// ---------------------------
// Fetch Writers
// ---------------------------
$writers = [];
$q2 = mysqli_query($conn, "SELECT * FROM writers ORDER BY name ASC");
while($r = mysqli_fetch_assoc($q2)) $writers[] = $r;


// ---------------------------
// Handle Form Submit
// ---------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $title = trim($_POST['title']);
    $category_id = intval($_POST['category_id']);
    $writer_id = intval($_POST['writer_id']);
    $description = trim($_POST['description']);

    // Validation
    if (!$title) $errors[] = "Title is required";
    if ($category_id <= 0) $errors[] = "Select a valid category";
    if ($writer_id <= 0) $errors[] = "Select a valid writer";

    // ---------------------------
    // Upload Cover Image
    // ---------------------------
    $cover_url = "";
    if (!empty($_FILES['cover']['name'])) {
        $ext = strtolower(pathinfo($_FILES['cover']['name'], PATHINFO_EXTENSION));
        if (!in_array($ext, ['jpg', 'jpeg', 'png'])) {
            $errors[] = "Cover must be JPG or PNG";
        } else {
            $new_name = "cover_" . time() . "." . $ext;
            $path = "../cover/" . $new_name;
            move_uploaded_file($_FILES['cover']['tmp_name'], $path);
            $cover_url = $new_name;
        }
    } else {
        $errors[] = "Cover image is required";
    }

    // ---------------------------
    // Upload PDF File
    // ---------------------------
    $pdf_url = "";
    if (!empty($_FILES['pdf']['name'])) {
        $ext = strtolower(pathinfo($_FILES['pdf']['name'], PATHINFO_EXTENSION));
        if ($ext != 'pdf') {
            $errors[] = "PDF file must be .pdf";
        } else {
            $new_name = "pdf_" . time() . ".pdf";
            $path = "../pdf/" . $new_name;
            move_uploaded_file($_FILES['pdf']['tmp_name'], $path);
            $pdf_url = $new_name;
        }
    } else {
        $errors[] = "PDF file is required";
    }
// Fetch Category Name
$cat_name = "";
$qc = mysqli_query($conn, "SELECT category FROM categories WHERE id=$category_id");
if ($row = mysqli_fetch_assoc($qc)) {
    $cat_name = $row['category'];
}

// Fetch Writer Name
$writer_name = "";
$qw = mysqli_query($conn, "SELECT name FROM writers WHERE id=$writer_id");
if ($row = mysqli_fetch_assoc($qw)) {
    $writer_name = $row['name'];
}


    // ---------------------------
    // Insert Book (if no errors)
    // ---------------------------
    if (empty($errors)) {
       $stmt = mysqli_prepare($conn, 
"INSERT INTO book 
(title, cover_url, pdf_url, category_id, writer_id, des, date_time, writer_name, category_name) 
VALUES (?,?,?,?,?,?,NOW(),?,?)"
);

mysqli_stmt_bind_param(
    $stmt,
    'sssissss',
    $title,
    $cover_url,
    $pdf_url,
    $category_id,
    $writer_id,
    $description,
    $writer_name,
    $cat_name
);
$stmt2 = mysqli_prepare($conn, 
"INSERT INTO books 
(title, cover_url, pdf_url, description, created_at, writer, category) 
VALUES (?,?,?,?,NOW(),?,?)"
);

mysqli_stmt_bind_param(
    $stmt2,
    'ssssss',
    $title,
    $cover_url,
    $pdf_url,
    $description,
    $writer_name,
    $cat_name
);


       $ok1 = mysqli_stmt_execute($stmt);
$ok2 = mysqli_stmt_execute($stmt2);

if ($ok1 && $ok2) {
    $success = "Book inserted successfully in both tables!";
} else {
    $errors[] = "Insert failed!";
}

mysqli_stmt_close($stmt);
mysqli_stmt_close($stmt2);

    }
}

?>


<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Add Book</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>
<body class="p-3">

<a href="index.php">&larr; Dashboard</a>
<h3>Add Book</h3>

<?php if(!empty($errors)): ?>
<div class="alert alert-danger">
    <?php echo implode("<br>", $errors); ?>
</div>
<?php endif; ?>

<?php if($success): ?>
<div class="alert alert-success">
    <?php echo $success; ?>
</div>
<?php endif; ?>


<form method="post" enctype="multipart/form-data">

<div class="form-group">
    <label>Title</label>
    <input name="title" class="form-control" value="<?php echo htmlspecialchars($_POST['title'] ?? ''); ?>">
</div>

<div class="form-row">
<div class="form-group col-md-6">
    <label>Category</label>
    <select name="category_id" class="form-control">
        <option value="0">Select Category</option>
        <?php foreach($cats as $c): ?>
            <option value="<?php echo $c['id']; ?>">
                <?php echo htmlspecialchars($c['category']); ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<div class="form-group col-md-6">
    <label>Writer</label>
    <select name="writer_id" class="form-control">
        <option value="0">Select Writer</option>
        <?php foreach($writers as $w): ?>
            <option value="<?php echo $w['id']; ?>">
                <?php echo htmlspecialchars($w['name']); ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>
</div>

<div class="form-group">
    <label>Description</label>
    <textarea name="description" class="form-control"><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
</div>

<div class="form-row">

<div class="form-group col-md-6">
    <label>Cover Image (jpg/png)</label>
    <input type="file" name="cover" class="form-control-file">
</div>

<div class="form-group col-md-6">
    <label>PDF File</label>
    <input type="file" name="pdf" class="form-control-file">
</div>

</div>

<button class="btn btn-success">Add Book</button>
</form>

</body>
</html>
