<?php
// Target URL
$url = "https://romanticgolpo.com/category/%E0%A6%86%E0%A6%AE%E0%A7%83%E0%A6%A4%E0%A7%8D%E0%A6%AF%E0%A7%81-%E0%A6%AD%E0%A6%BE%E0%A6%B2%E0%A7%8B%E0%A6%AC%E0%A6%BE%E0%A6%B8%E0%A6%BF-%E0%A6%A4%E0%A7%8B%E0%A6%95%E0%A7%87/";

// Step 1: Get HTML
$html = file_get_contents($url);
if (!$html) {
    die("Failed to fetch URL!");
}

// Step 2: Load into DOM
libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
libxml_clear_errors();

// Step 3: Create XPath
$xpath = new DOMXPath($dom);

// Step 4: Find all story blocks (they have class `td_module_2`)
$items = $xpath->query("//div[contains(@class, 'td_module_2')]");

// Step 5: Loop through and extract data
foreach ($items as $item) {
    // Get title link
    $aTag = $xpath->query(".//h3[@class='entry-title td-module-title']/a", $item)->item(0);
    $title = $aTag ? trim($aTag->nodeValue) : '';
    $link  = $aTag ? $aTag->getAttribute('href') : '';

    // Get image URL (data-src or src)
    $imgTag = $xpath->query(".//img", $item)->item(0);
    $img = '';
    if ($imgTag) {
        $img = $imgTag->getAttribute('data-src') ?: $imgTag->getAttribute('src');
    }

    // Get excerpt (if exists)
    $excerptTag = $xpath->query(".//div[contains(@class, 'td-excerpt')]", $item)->item(0);
    $excerpt = $excerptTag ? trim($excerptTag->nodeValue) : '';

echo "$title<br>";
//echo "Link: $link<br>";
//echo "Image: $img<br>";
//echo "Excerpt: $excerpt<br><br>";
//echo'আমৃত্যু ভালোবাসি তোকে<br><br>';
books($link);
}


function books($url){


// URL of the story
//$url = 'https://romanticgolpo.com/%e0%a6%86%e0%a6%ae%e0%a7%83%e0%a6%a4%e0%a7%8d%e0%a6%af%e0%a7%81-%e0%a6%ad%e0%a6%be%e0%a6%b2%e0%a7%8b%e0%a6%ac%e0%a6%be%e0%a6%b8%e0%a6%bf-%e0%a6%a4%e0%a7%8b%e0%a6%95%e0%a7%87-%e0%a6%aa%e0%a6%b0-5/';

// Initialize cURL to fetch the webpage content
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Optional: Disable SSL verification (use with caution)
$html = curl_exec($ch);
curl_close($ch);

// Check if the content was fetched successfully
if ($html === false) {
    die('Failed to fetch the webpage.');
}

// Create a new DOMDocument instance
$doc = new DOMDocument();

// Suppress warnings for malformed HTML
libxml_use_internal_errors(true);
$doc->loadHTML($html);
libxml_clear_errors();

// Create a DOMXPath instance to query the document
$xpath = new DOMXPath($doc);

// Find the div with class "td-post-content tagdiv-type" which contains the story
$storyDiv = $xpath->query('//div[@class="td-post-content tagdiv-type"]')->item(0);

if ($storyDiv) {
    // Define phrases to exclude (partial matches)
    $excludePhrases = [
        'আমৃত্যু ভালোবাসি তোকে পর্ব ১',
        'লেখনীতে সালমা চৌধুরী',
        'আরও গল্প পড়তে এখানে ক্লিক করুন',
        'আমৃত্যু ভালোবাসি তোকে পর্ব ২'
    ];

 $storyText = ''; // raw HTML রাখার জন্য

foreach ($storyDiv->childNodes as $node) {
    // Skip ad blocks (divs with class starting with "code-block")
    if ($node->nodeName === 'div' && strpos($node->getAttribute('class'), 'code-block') !== false) {
        continue;
    }

    // Get raw HTML exactly as it appears
    $rawHtml = $node->ownerDocument->saveHTML($node);

    // Skip excluded phrases (if needed)
    $skip = false;
    foreach ($excludePhrases as $phrase) {
        if (strpos($rawHtml, $phrase) !== false) {
            $skip = true;
            break;
        }
    }

    if (!$skip) {
        // Keep the HTML as-is (no trimming, no space removal)
        $storyText .= $rawHtml;
    }
}


    // Clean the text: remove extra spaces, multiple spaces, and normalize
   // $storyText = preg_replace('/\s+/', ' ', trim($storyText));

    // Output the cleaned story text
    echo $storyText.'<br>';
} else {
    echo 'Story content not found.';
}


}





?>
