<?php
require 'db.php';

// প্রতিটি book_request কতবার এসেছে সেটা count করো
$sql = "
    SELECT 
    TRIM(LOWER(book_request)) AS clean_name,
    SOUNDEX(TRIM(LOWER(book_request))) AS sound_code,
    COUNT(*) AS total_requests,
    GROUP_CONCAT(book_request SEPARATOR ', ') AS similar_variants
FROM 
    book_requests
GROUP BY 
    sound_code
ORDER BY 
    total_requests DESC;

";

$result = mysqli_query($conn, $sql);

$data = [];

while ($row = mysqli_fetch_assoc($result)) {
    $data[] = $row;
}

header('Content-Type: application/json');
echo json_encode([
    "Total Unique Books" => count($data),
    "Data" => $data
]);
