<?php
require 'db_connect.php';
$rs = mysqli_query($conn, "SELECT b.id,b.title,c.category,w.name,b.cover_url,b.pdf_url,b.date_time FROM book b JOIN categories c ON b.category_id=c.id JOIN writers w ON b.writer_id=w.id ORDER BY b.id DESC");

// কভার এবং PDF এর জন্য বেস URL সেট করুন
$base_cover_url = "https://helalkhan.top/APP/books/cover/";
$base_pdf_url = "https://helalkhan.top/APP/books/pdf/";

?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Books</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>
<body class="p-3">
<a href="index.php">&larr; Dashboard</a>
<h3>Books</h3>
<table class="table table-bordered table-sm">
<thead><tr><th>ID</th><th>Title</th><th>Category</th><th>Writer</th><th>Cover</th><th>PDF</th><th>Date</th></tr></thead>
<tbody>
<?php while($b = mysqli_fetch_assoc($rs)){
    
    // সম্পূর্ণ কভার URL তৈরি করা হলো
    $cover_full_url = $base_cover_url . urlencode($b['cover_url']);
    $cover = $b['cover_url'] ? "<img src='{$cover_full_url}' style='height:60px'>" : '';
    
    // সম্পূর্ণ PDF URL তৈরি করা হলো
    $pdf_full_url = $base_pdf_url . urlencode($b['pdf_url']);
    $pdf = $b['pdf_url'] ? "<a href='{$pdf_full_url}' target='_blank'>View PDF</a>" : '';
    
    echo "<tr><td>{$b['id']}</td><td>{$b['title']}</td><td>{$b['category']}</td><td>{$b['name']}</td><td>$cover</td><td>$pdf</td><td>{$b['date_time']}</td></tr>";
} ?>
</tbody>
</table>
</body>
</html>