<?php
require 'db_connect.php';

$errors = [];
$success = "";

// ১. বেস ইউআরএল এবং পাথ সেট করা
$base_url = "https://helalkhan.top/APP/books/";
$pdf_upload_dir = "../pdf/";    // ড্যাশবোর্ড থেকে এক ধাপ বাইরে পিডিএফ ফোল্ডার
$cover_upload_dir = "../cover/"; // ড্যাশবোর্ড থেকে এক ধাপ বাইরে কভার ফোল্ডার

// ক্যাটাগরি এবং রাইটার লিস্ট নিয়ে আসা (ড্রপডাউনের জন্য)
$cats = [];
$q1 = mysqli_query($conn, "SELECT * FROM categories ORDER BY category ASC");
while($r = mysqli_fetch_assoc($q1)) $cats[] = $r;

$writers = [];
$q2 = mysqli_query($conn, "SELECT * FROM writers ORDER BY name ASC");
while($r = mysqli_fetch_assoc($q2)) $writers[] = $r;

// ফর্মার সাবমিট হ্যান্ডেল করা
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $title = trim($_POST['title']);
    $category_id = intval($_POST['category_id']);
    $new_category = trim($_POST['new_category']);
    $writer_id = intval($_POST['writer_id']);
    $new_writer = trim($_POST['new_writer']);
    $description = trim($_POST['description']);

    // ২. ক্যাটাগরি লজিক (সিলেক্ট অথবা নতুন তৈরি)
    $cat_name = "";
    if (!empty($new_category)) {
        $stmt_check_cat = mysqli_prepare($conn, "SELECT id, category FROM categories WHERE category = ?");
        mysqli_stmt_bind_param($stmt_check_cat, "s", $new_category);
        mysqli_stmt_execute($stmt_check_cat);
        $res_cat = mysqli_stmt_get_result($stmt_check_cat);
        if ($row = mysqli_fetch_assoc($res_cat)) {
            $category_id = $row['id'];
            $cat_name = $row['category'];
        } else {
            $stmt_ins_cat = mysqli_prepare($conn, "INSERT INTO categories (category) VALUES (?)");
            mysqli_stmt_bind_param($stmt_ins_cat, "s", $new_category);
            mysqli_stmt_execute($stmt_ins_cat);
            $category_id = mysqli_insert_id($conn);
            $cat_name = $new_category;
        }
    } elseif ($category_id > 0) {
        $qc = mysqli_query($conn, "SELECT category FROM categories WHERE id=$category_id");
        if ($row = mysqli_fetch_assoc($qc)) $cat_name = $row['category'];
    }

    // ৩. রাইটার লজিক (সিলেক্ট অথবা নতুন তৈরি)
    $writer_name = "";
    if (!empty($new_writer)) {
        $stmt_check_writer = mysqli_prepare($conn, "SELECT id, name FROM writers WHERE name = ?");
        mysqli_stmt_bind_param($stmt_check_writer, "s", $new_writer);
        mysqli_stmt_execute($stmt_check_writer);
        $res_writer = mysqli_stmt_get_result($stmt_check_writer);
        if ($row = mysqli_fetch_assoc($res_writer)) {
            $writer_id = $row['id'];
            $writer_name = $row['name'];
        } else {
            $stmt_ins_writer = mysqli_prepare($conn, "INSERT INTO writers (name) VALUES (?)");
            mysqli_stmt_bind_param($stmt_ins_writer, "s", $new_writer);
            mysqli_stmt_execute($stmt_ins_writer);
            $writer_id = mysqli_insert_id($conn);
            $writer_name = $new_writer;
        }
    } elseif ($writer_id > 0) {
        $qw = mysqli_query($conn, "SELECT name FROM writers WHERE id=$writer_id");
        if ($row = mysqli_fetch_assoc($qw)) $writer_name = $row['name'];
    }

    // ৪. ভ্যালিডেশন
    if (!$title) $errors[] = "বইয়ের টাইটেল প্রয়োজন!";
    if (!$cat_name) $errors[] = "ক্যাটাগরি সিলেক্ট করুন অথবা লিখুন!";
    if (!$writer_name) $errors[] = "লেখকের নাম সিলেক্ট করুন অথবা লিখুন!";

    // ৫. কভার ইমেজ আপলোড
    $cover_url_db = "";
    if (!empty($_FILES['cover']['name'])) {
        $ext = strtolower(pathinfo($_FILES['cover']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png'])) {
            $new_cover = "cover_" . time() . "." . $ext;
            if (move_uploaded_file($_FILES['cover']['tmp_name'], $cover_upload_dir . $new_cover)) {
                $cover_url_db = $new_cover; // কভারের ক্ষেত্রে শুধু নাম সেভ হবে
            }
        } else { $errors[] = "কভার ইমেজ শুধুমাত্র JPG বা PNG হতে হবে!"; }
    } else { $errors[] = "কভার ইমেজ দিতেই হবে!"; }

    // ৬. পিডিএফ ফাইল আপলোড এবং ফুল লিঙ্ক তৈরি
    $pdf_url_db = "";
    if (!empty($_FILES['pdf']['name'])) {
        $ext = strtolower(pathinfo($_FILES['pdf']['name'], PATHINFO_EXTENSION));
        if ($ext == 'pdf') {
            $new_pdf = "pdf_" . time() . ".pdf";
            if (move_uploaded_file($_FILES['pdf']['tmp_name'], $pdf_upload_dir . $new_pdf)) {
                $pdf_url_db = $base_url . "pdf/" . $new_pdf; // এখানে ফুল লিঙ্ক তৈরি হচ্ছে
            }
        } else { $errors[] = "ফাইলটি অবশ্যই PDF হতে হবে!"; }
    } else { $errors[] = "পিডিএফ ফাইল দিতেই হবে!"; }

    // ৭. ডাটাবেজে সেভ করা
    if (empty($errors)) {
        // Table: book
        $st1 = mysqli_prepare($conn, "INSERT INTO book (title, cover_url, pdf_url, category_id, writer_id, des, date_time, writer_name, category_name) VALUES (?,?,?,?,?,?,NOW(),?,?)");
        mysqli_stmt_bind_param($st1, 'sssissss', $title, $cover_url_db, $pdf_url_db, $category_id, $writer_id, $description, $writer_name, $cat_name);
        
        // Table: books
        $st2 = mysqli_prepare($conn, "INSERT INTO books (title, cover_url, pdf_url, description, created_at, writer, category) VALUES (?,?,?,?,NOW(),?,?)");
        mysqli_stmt_bind_param($st2, 'ssssss', $title, $cover_url_db, $pdf_url_db, $description, $writer_name, $cat_name);

        if (mysqli_stmt_execute($st1) && mysqli_stmt_execute($st2)) {
            $success = "বইটি সফলভাবে যুক্ত হয়েছে এবং পিডিএফ লিঙ্ক সেভ হয়েছে!";
            $title=$title.' বইটি সফলভাবে যুক্ত হয়েছ' ;
            send_message($title,$description);

        } else {
            $errors[] = "ডাটাবেজে সেভ করতে সমস্যা হয়েছে!";
        }
    }
}



function send_message($title,$message){
    
    require_once __DIR__ . '/get_access_token.php';

$PROJECT_ID = "uponnash-bd6cf";
$ACCESS_TOKEN = getAccessToken(__DIR__ . "/service-account.json");

$url = "https://fcm.googleapis.com/v1/projects/$PROJECT_ID/messages:send";

// Data-only payload (foreground + background handled)
$message = [
    "message" => [
        "topic" => "all",
        "data" => [
            "title" =>$title,
            "time"=>"". time(),
            "body"  =>$message,
            "type"  => "new_book",
            "book_id" => "123",
            "isShow" => "1" // 1 -> show, 0 -> skip
        ],
        "android" => [
            "priority" => "HIGH"
        ]
    ]
];

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $ACCESS_TOKEN",
        "Content-Type: application/json"
    ],
    CURLOPT_POSTFIELDS => json_encode($message)
]);

$response = curl_exec($ch);
curl_close($ch);

echo $response;
    
    
}

?>

<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Add New Book | Professional Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body { background: #f4f7f6; font-family: 'Hind Siliguri', sans-serif; }
        .form-card { border-radius: 15px; border: none; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .form-header { background: #6f42c1; color: #fff; border-radius: 15px 15px 0 0; padding: 20px; text-align: center; }
        .btn-publish { background: #6f42c1; color: white; border-radius: 10px; padding: 12px; font-weight: 600; width: 100%; border: none; }
        .btn-publish:hover { background: #5a32a3; color: white; }
        .or-text { font-size: 11px; color: #888; text-align: center; margin: 5px 0; font-weight: bold; }
        .file-box { border: 2px dashed #ddd; padding: 15px; border-radius: 10px; background: #fafafa; }
    </style>
</head>
<body class="py-5">

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-9">
            <div class="mb-3">
                <a href="index.php" class="text-muted"><i class="fas fa-arrow-left"></i> ড্যাশবোর্ডে ফিরে যান</a>
            </div>

            <div class="card form-card">
                <div class="form-header">
                    <h4 class="mb-0"><i class="fas fa-book-medical mr-2"></i> নতুন বই যোগ করুন</h4>
                </div>
                <div class="card-body p-4">
                    
                    <?php if(!empty($errors)): ?>
                        <div class="alert alert-danger"><?php echo implode("<br>", $errors); ?></div>
                    <?php endif; ?>

                    <?php if($success): ?>
                        <div class="alert alert-success"><i class="fas fa-check-circle mr-1"></i> <?php echo $success; ?></div>
                    <?php endif; ?>

                    <form method="post" enctype="multipart/form-data">
                        <div class="form-group">
                            <label>বইয়ের নাম (Title)</label>
                            <input name="title" class="form-control" placeholder="বইয়ের নাম লিখুন" value="<?php echo htmlspecialchars($_POST['title'] ?? ''); ?>">
                        </div>

                        <div class="form-row">
                            <div class="col-md-6 form-group">
                                <label>ক্যাটাগরি</label>
                                <select name="category_id" class="form-control">
                                    <option value="0">-- বিদ্যমান ক্যাটাগরি --</option>
                                    <?php foreach($cats as $c): ?>
                                        <option value="<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['category']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <div class="or-text">অথবা নতুন ক্যাটাগরি তৈরি করুন</div>
                                <input name="new_category" class="form-control form-control-sm" placeholder="নতুন ক্যাটাগরির নাম">
                            </div>

                            <div class="col-md-6 form-group">
                                <label>লেখক</label>
                                <select name="writer_id" class="form-control">
                                    <option value="0">-- বিদ্যমান লেখক --</option>
                                    <?php foreach($writers as $w): ?>
                                        <option value="<?php echo $w['id']; ?>"><?php echo htmlspecialchars($w['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <div class="or-text">অথবা নতুন লেখকের নাম লিখুন</div>
                                <input name="new_writer" class="form-control form-control-sm" placeholder="নতুন লেখকের নাম">
                            </div>
                        </div>

                        <div class="form-group">
                            <label>বইয়ের বর্ণনা (Description)</label>
                            <textarea name="description" class="form-control" rows="3"><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
                        </div>

                        <div class="form-row">
                            <div class="col-md-6 form-group">
                                <label>কভার ইমেজ</label>
                                <div class="file-box">
                                    <input type="file" name="cover" class="form-control-file">
                                </div>
                            </div>
                            <div class="col-md-6 form-group">
                                <label>পিডিএফ ফাইল</label>
                                <div class="file-box">
                                    <input type="file" name="pdf" class="form-control-file">
                                </div>
                            </div>
                        </div>

                        <button class="btn btn-publish mt-3 shadow">
                            <i class="fas fa-upload mr-1"></i> পাবলিশ করুন
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>