<?php
require('db_connect.php');

header("Content-Type: application/json; charset=utf-8");
ini_set('display_errors',0);
error_reporting(E_ALL);

mysqli_set_charset($conn,'utf8mb4');

$response = [];

$topSql = "SELECT * FROM book ORDER BY click DESC LIMIT 5";
$topRes = mysqli_query($conn,$topSql);

if(!$topRes){
    echo json_encode(['status'=>'error','message'=>'Top reading failed']);
    exit;
}

$top = [];
while($row = mysqli_fetch_assoc($topRes)){
    $top[] = $row;
}

$recentSql = "SELECT * FROM book ORDER BY date_time DESC LIMIT 5";
$recentRes = mysqli_query($conn,$recentSql);

if(!$recentRes){
    echo json_encode(['status'=>'error','message'=>'Recent failed']);
    exit;
}

$recent = [];
while($row = mysqli_fetch_assoc($recentRes)){
    $recent[] = $row;
}

echo json_encode([
    'path' => 'https://helalkhan.top/APP/books/',
    'Top Reading' => $top,
    'Recently Added' => $recent
], JSON_UNESCAPED_UNICODE);
exit;
