<?php
//opcache_reset();
require 'db_connect.php';
header("Content-Type: application/json; charset=utf-8");

// ======================================================
// Helper functions
// ======================================================

function fetch_all(mysqli $conn, string $sql): array {
    $result = mysqli_query($conn, $sql);
    if ($result === false) return [];

    $rows = [];
    while ($r = mysqli_fetch_assoc($result)) {
        $rows[] = $r;
    }
    return $rows;
}

function get_recent_books(mysqli $conn, int $limit = 5): array {
    $sql = "SELECT * FROM book ORDER BY date_time DESC LIMIT " . intval($limit);
    return fetch_all($conn, $sql);
}

function get_top_books(mysqli $conn, int $limit = 5): array {
    $sql = "SELECT * FROM book ORDER BY click DESC LIMIT " . intval($limit);
    return fetch_all($conn, $sql);
}

function get_writers(mysqli $conn, int $limit = 0): array {
    $sql = $limit > 0 ? "SELECT * FROM writers LIMIT " . intval($limit) : "SELECT * FROM writers";
    return fetch_all($conn, $sql);
}

function get_categories(mysqli $conn, int $limit = 0): array {
    $sql = $limit > 0 ? "SELECT * FROM categories LIMIT " . intval($limit) : "SELECT * FROM categories";
    return fetch_all($conn, $sql);
}

function get_books_by_category(mysqli $conn, int $category_id, int $limit = 5): array {
    $cat_id = intval($category_id);
    $sql = "SELECT * FROM book WHERE category_id='" . $cat_id . "' LIMIT " . intval($limit);
    return fetch_all($conn, $sql);
}

function get_books_by_writer(mysqli $conn, int $writer_id, int $limit = 5): array {
    $w_id = intval($writer_id);
    $sql = "SELECT * FROM book WHERE writer_id='" . $w_id . "' LIMIT " . intval($limit);
    return fetch_all($conn, $sql);
}

function build_category_items(mysqli $conn, int $cat_limit = 2, int $books_per_cat = 5): array {
    $cats = get_categories($conn, $cat_limit);
    $items = [];

    foreach ($cats as $cat) {
        $books_list = get_books_by_category($conn, $cat['id'], $books_per_cat);
        $items[] = [
            'type' => 'category',
            'id' => $cat['id'],
            'category' => $cat['category'] ?? null,
            'image' => $cat['image'] ?? null,
            'books' => $books_list,
        ];
    }

    return $items;
}

function build_writer_items(mysqli $conn, int $writer_limit = 2, int $books_per_writer = 5): array {
    $writers = get_writers($conn, $writer_limit);
    $items = [];

    foreach ($writers as $w) {
        $books_list = get_books_by_writer($conn, $w['id'], $books_per_writer);
        $items[] = [
            'type' => 'writer',
            'id' => $w['id'],
            'name' => $w['name'] ?? null,
            'cover_url' => $w['cover_url'] ?? null,
            'books' => $books_list,
        ];
    }

    return $items;
}

function interleave_arrays(array $a, array $b): array {
    $mixed = [];
    $max = max(count($a), count($b));

    for ($i = 0; $i < $max; $i++) {
        if (isset($a[$i])) $mixed[] = $a[$i];
        if (isset($b[$i])) $mixed[] = $b[$i];
    }

    return $mixed;
}

// ======================================================
// Main
// ======================================================

$books = [];
$books["path"]='https://helalkhan.top/APP/books/';

// Recently added and top reading
$books['Top Reading'] = get_top_books($conn, 5);

$books['Recently Added'] = get_recent_books($conn, 5);


// Full category list for response (no limit)
$books['category'] = get_categories($conn);

// Writers (full list)
$books['writers'] = get_writers($conn);

// Mixed: interleave category items and writer items (limited sets)
$cat_items = build_category_items($conn, 2, 5);
$writer_items = build_writer_items($conn, 2, 5);
$books['mixed'] = interleave_arrays($cat_items, $writer_items);

// Output as JSON
echo json_encode($books, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

// End of file
