<?php
require('db_connect.php');


$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    echo json_encode(["error" => "invalid_id"]);
    exit;
}

$stmt = $conn->prepare(
    "SELECT click, fav, down, `des` FROM book WHERE id = ?"
);

$stmt->bind_param("i", $id);
$stmt->execute();

$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        "click" => (int)$row['click'],
        "fav"   => (int)$row['fav'],
        "down"  => (int)$row['down'],
         "des"  =>$row['des']
    ]);
} else {
    echo json_encode(["error" => "not_found"]);
}

$stmt->close();
$conn->close();
