<!-- ========== writers.php ========== -->
<?php
require 'db_connect.php';
$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['writer_name'])){
$w = trim($_POST['writer_name']);
if($w === '') $errors[] = 'Writer name required';
if(empty($errors)){
$stmt = mysqli_prepare($conn, "INSERT INTO writers(name) VALUES(?)");
mysqli_stmt_bind_param($stmt, 's', $w);
$ok = mysqli_stmt_execute($stmt);
if(!$ok){
$errors[] = 'Insert failed or writer exists';
}
mysqli_stmt_close($stmt);
}
}
$writers = mysqli_query($conn, "SELECT * FROM writers ORDER BY id DESC");
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Writers</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>
<body class="p-3">
<a href="index.php">&larr; Dashboard</a>
<h3>Writers</h3>
<?php if($errors) echo '<div class="alert alert-danger">'.implode('<br>', $errors).'</div>'; ?>
<form method="post" class="form-inline mb-3">
<input name="writer_name" class="form-control mr-2" placeholder="New writer">
<button class="btn btn-primary">Add</button>
</form>
<table class="table table-bordered table-sm">
<thead><tr><th>ID</th><th>Name</th></tr></thead>
<tbody>
<?php while($w = mysqli_fetch_assoc($writers)){ echo "<tr><td>{$w['id']}</td><td>{$w['name']}</td></tr>"; } ?>
</tbody>
</table>
</body>
</html>

