<!-- ========== index.php (Dashboard) ========== -->
<?php
require 'db_connect.php';
// Simple dashboard counters
$c1 = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM book"))['c'];
$c2 = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM categories"))['c'];
$c3 = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM writers"))['c'];
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Panel - Dashboard</title>
<!-- AdminLTE & Bootstrap CDN -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
<a class="navbar-brand" href="#">My Admin</a>
<div class="ml-auto">
<a class="btn btn-outline-light" href="categories.php">Categories</a>
<a class="btn btn-outline-light" href="writers.php">Writers</a>
<a class="btn btn-outline-light" href="books.php">Books</a>
<a class="btn btn-outline-light" href="book_add.php">Add Book</a>
</div>
</nav>


<div class="container mt-4">
<div class="row">
<div class="col-md-4">
<div class="card">
<div class="card-body">
<h5>Books</h5>
<h2><?php echo $c1; ?></h2>
</div>
</div>
</div>
<div class="col-md-4">
<div class="card">
<div class="card-body">
<h5>Categories</h5>
<h2><?php echo $c2; ?></h2>
</div>
</div>
</div>
<div class="col-md-4">
<div class="card">
<div class="card-body">
<h5>Writers</h5>
<h2><?php echo $c3; ?></h2>
</div>
</div>
</div>
</div>


<div class="mt-4">
<h4>Recently Added Books</h4>
<table class="table table-sm table-striped">
<thead><tr><th>ID</th><th>Title</th><th>Category</th><th>Writer</th><th>Date</th></tr></thead>
<tbody>
<?php
$rs = mysqli_query($conn, "SELECT b.id,b.title,c.category,w.name,b.date_time FROM book b JOIN categories c ON b.category_id=c.id JOIN writers w ON b.writer_id=w.id ORDER BY b.id DESC LIMIT 10");
while($r = mysqli_fetch_assoc($rs)){
echo "<tr><td>{$r['id']}</td><td>{$r['title']}</td><td>{$r['category']}</td><td>{$r['name']}</td><td>{$r['date_time']}</td></tr>";
}
?>
</tbody>
</table>
</div>
</div>


</body>
</html>

