

<!-- ========== categories.php ========== -->
<?php
require 'db_connect.php';
$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['category_name'])){
$cat = trim($_POST['category_name']);
if($cat === '') $errors[] = 'Category required';
if(empty($errors)){
// prepared statement to avoid duplicates and SQL injection
$stmt = mysqli_prepare($conn, "INSERT INTO categories(category) VALUES(?)");
mysqli_stmt_bind_param($stmt, 's', $cat);
$ok = mysqli_stmt_execute($stmt);
if(!$ok){
$errors[] = 'Insert failed or category exists';
}
mysqli_stmt_close($stmt);
}
}
$cats = mysqli_query($conn, "SELECT * FROM categories ORDER BY id DESC");
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Categories</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>
<body class="p-3">
<a href="index.php">&larr; Dashboard</a>
<h3>Categories</h3>
<?php if($errors) echo '<div class="alert alert-danger">'.implode('<br>', $errors).'</div>'; ?>
<form method="post" class="form-inline mb-3">
<input name="category_name" class="form-control mr-2" placeholder="New category">
<button class="btn btn-primary">Add</button>
</form>
<table class="table table-bordered table-sm">
<thead><tr><th>ID</th><th>Category</th></tr></thead>
<tbody>
<?php while($c = mysqli_fetch_assoc($cats)){ echo "<tr><td>{$c['id']}</td><td>{$c['category']}</td></tr>"; } ?>
</tbody>
</table>
</body>
</html>

