<?php
include "db.php"; // তোমার ডাটাবেস কানেকশন ফাইল

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_name = $_POST['user_name'];
    $user_details = $_POST['user_details'];
    $book_request = $_POST['book_request'];

    if (!empty($user_name) && !empty($book_request)) {
        $stmt = $conn->prepare("INSERT INTO book_requests (user_name, user_details, book_request) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $user_name, $user_details, $book_request);

        if ($stmt->execute()) {
            echo json_encode(["status" => "success", "message" => "Request submitted"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Database error"]);
        }
        $stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Missing fields"]);
    }
}
?>
