<?php

function getAccessToken($serviceAccountPath) {

    $json = json_decode(file_get_contents($serviceAccountPath), true);

    $now = time();
    $header = [
        "alg" => "RS256",
        "typ" => "JWT"
    ];

    $payload = [
        "iss"   => $json['client_email'],
        "scope" => "https://www.googleapis.com/auth/firebase.messaging",
        "aud"   => "https://oauth2.googleapis.com/token",
        "iat"   => $now,
        "exp"   => $now + 3600
    ];

    $base64Header = rtrim(strtr(base64_encode(json_encode($header)), '+/', '-_'), '=');
    $base64Payload = rtrim(strtr(base64_encode(json_encode($payload)), '+/', '-_'), '=');

    $data = $base64Header . "." . $base64Payload;

    openssl_sign($data, $signature, $json['private_key'], "SHA256");
    $jwt = $data . "." . rtrim(strtr(base64_encode($signature), '+/', '-_'), '=');

    $ch = curl_init("https://oauth2.googleapis.com/token");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ["Content-Type: application/x-www-form-urlencoded"],
        CURLOPT_POSTFIELDS => http_build_query([
            "grant_type" => "urn:ietf:params:oauth:grant-type:jwt-bearer",
            "assertion"  => $jwt
        ])
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    return $result['access_token'] ?? null;
}
